/*
 * JavaScript to handle drag operations, including automatic scrolling.
 *
 * Note: this module is defined statically. It is a singleton. You
 * can only have one use of it active at any time. However, you
 * can only drag one thing at a time, this is not a problem in practice.
 *
 * @module     core/dragdrop
 * @class      dragdrop
 * @package    core
 * @copyright  2016 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.6
 */
define("core/dragdrop",["jquery","core/autoscroll"],(function($,autoScroll){var dragdrop={eventCaptureOptions:{passive:!1,capture:!0},dragProxy:null,onMove:null,onDrop:null,initialPosition:null,initialX:null,initialY:null,touching:null,prepare:function(event){if(event.preventDefault(),"touchstart"===event.type?null===dragdrop.touching&&event.changedTouches.length>0:1===event.which){var details=dragdrop.getEventXY(event);return details.start=!0,details}return{start:!1}},start:function(event,dragProxy,onMove,onDrop){var xy=dragdrop.getEventXY(event);switch(dragdrop.initialX=xy.x,dragdrop.initialY=xy.y,dragdrop.initialPosition=dragProxy.offset(),dragdrop.dragProxy=dragProxy,dragdrop.onMove=onMove,dragdrop.onDrop=onDrop,event.type){case"mousedown":dragdrop.addEventSpecial("mousemove",dragdrop.mouseMove),dragdrop.addEventSpecial("mouseup",dragdrop.mouseUp);break;case"touchstart":dragdrop.addEventSpecial("touchend",dragdrop.touchEnd),dragdrop.addEventSpecial("touchcancel",dragdrop.touchEnd),dragdrop.addEventSpecial("touchmove",dragdrop.touchMove),dragdrop.touching=event.changedTouches[0].identifier;break;default:throw new Error("Unexpected event type: "+event.type)}autoScroll.start(dragdrop.scroll)},addEventSpecial:function(event,handler){try{window.addEventListener(event,handler,dragdrop.eventCaptureOptions)}catch(ex){dragdrop.eventCaptureOptions=!0,window.addEventListener(event,handler,dragdrop.eventCaptureOptions)}},getEventXY:function(event){switch(event.type){case"touchstart":return{x:event.changedTouches[0].pageX,y:event.changedTouches[0].pageY};case"mousedown":return{x:event.pageX,y:event.pageY};default:throw new Error("Unexpected event type: "+event.type)}},touchMove:function(e){e.preventDefault();for(var i=0;i<e.changedTouches.length;i++)e.changedTouches[i].identifier===dragdrop.touching&&dragdrop.handleMove(e.changedTouches[i].pageX,e.changedTouches[i].pageY)},mouseMove:function(e){dragdrop.handleMove(e.pageX,e.pageY)},handleMove:function(pageX,pageY){var current=dragdrop.dragProxy.offset(),topOffset=current.top-parseInt(dragdrop.dragProxy.css("top")),leftOffset=current.left-parseInt(dragdrop.dragProxy.css("left")),maxY=$(document).height()-dragdrop.dragProxy.outerHeight()-topOffset,maxX=$(document).width()-dragdrop.dragProxy.outerWidth()-leftOffset,minY=-topOffset,minX=-leftOffset,initial=dragdrop.initialPosition,position={top:Math.max(minY,Math.min(maxY,initial.top+(pageY-dragdrop.initialY)-topOffset)),left:Math.max(minX,Math.min(maxX,initial.left+(pageX-dragdrop.initialX)-leftOffset))};dragdrop.dragProxy.css(position),dragdrop.onMove(pageX,pageY,dragdrop.dragProxy)},touchEnd:function(e){e.preventDefault();for(var i=0;i<e.changedTouches.length;i++)e.changedTouches[i].identifier===dragdrop.touching&&dragdrop.handleEnd(e.changedTouches[i].pageX,e.changedTouches[i].pageY)},mouseUp:function(e){dragdrop.handleEnd(e.pageX,e.pageY)},handleEnd:function(pageX,pageY){null!==dragdrop.touching?(window.removeEventListener("touchend",dragdrop.touchEnd,dragdrop.eventCaptureOptions),window.removeEventListener("touchcancel",dragdrop.touchEnd,dragdrop.eventCaptureOptions),window.removeEventListener("touchmove",dragdrop.touchMove,dragdrop.eventCaptureOptions),dragdrop.touching=null):(window.removeEventListener("mousemove",dragdrop.mouseMove,dragdrop.eventCaptureOptions),window.removeEventListener("mouseup",dragdrop.mouseUp,dragdrop.eventCaptureOptions)),autoScroll.stop(),dragdrop.onDrop(pageX,pageY,dragdrop.dragProxy)},scroll:function(offset){var maxY=$(document).height()-dragdrop.dragProxy.outerHeight(),currentPosition=dragdrop.dragProxy.offset();currentPosition.top=Math.min(maxY,currentPosition.top+offset),dragdrop.dragProxy.css(currentPosition)}};return{prepare:dragdrop.prepare,start:dragdrop.start}}));

//# sourceMappingURL=dragdrop.min.js.map