define("tool_usertours/tour",["exports","jquery","core/aria","core/popper"],(function(_exports,_jquery,Aria,_popper){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}function _defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),Aria=function(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!==_typeof(obj)&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}newObj.default=obj,cache&&cache.set(obj,newObj);return newObj}(Aria),_popper=_interopRequireDefault(_popper);var Tour=function(){function Tour(config){!function(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}(this,Tour),this.init(config)}var Constructor,protoProps,staticProps;return Constructor=Tour,protoProps=[{key:"init",value:function(config){this.eventHandlers={},this.reset(),this.originalConfiguration=config||{},this.configure.apply(this,arguments);try{this.storage=window.sessionStorage,this.storageKey="tourstate_"+this.tourName}catch(e){this.storage=!1,this.storageKey=""}return this}},{key:"reset",value:function(){return this.hide(),this.eventHandlers=[],this.resetStepListeners(),this.originalConfiguration={},this.steps=[],this.currentStepNumber=0,this}},{key:"configure",value:function(config){var _this=this;if("object"===_typeof(config)){if(void 0!==config.tourName&&(this.tourName=config.tourName),config.eventHandlers){var _loop=function(eventName){config.eventHandlers[eventName].forEach((function(handler){this.addEventHandler(eventName,handler)}),_this)};for(var eventName in config.eventHandlers)_loop(eventName)}this.resetStepDefaults(!0),"object"===_typeof(config.steps)&&(this.steps=config.steps),void 0!==config.template&&(this.templateContent=config.template)}return this.checkMinimumRequirements(),this}},{key:"checkMinimumRequirements",value:function(){if(!this.tourName)throw new Error("Tour Name required");if(!this.steps||!this.steps.length)throw new Error("Steps must be specified")}},{key:"resetStepDefaults",value:function(loadOriginalConfiguration){return void 0===loadOriginalConfiguration&&(loadOriginalConfiguration=!0),this.stepDefaults={},loadOriginalConfiguration&&void 0!==this.originalConfiguration.stepDefaults?this.setStepDefaults(this.originalConfiguration.stepDefaults):this.setStepDefaults({}),this}},{key:"setStepDefaults",value:function(stepDefaults){return this.stepDefaults||(this.stepDefaults={}),_jquery.default.extend(this.stepDefaults,{element:"",placement:"top",delay:0,moveOnClick:!1,moveAfterTime:0,orphan:!1,direction:1},stepDefaults),this}},{key:"getCurrentStepNumber",value:function(){return parseInt(this.currentStepNumber,10)}},{key:"setCurrentStepNumber",value:function(stepNumber){if(this.currentStepNumber=stepNumber,this.storage)try{this.storage.setItem(this.storageKey,stepNumber)}catch(e){e.code===DOMException.QUOTA_EXCEEDED_ERR&&this.storage.removeItem(this.storageKey)}}},{key:"getNextStepNumber",value:function(stepNumber){void 0===stepNumber&&(stepNumber=this.getCurrentStepNumber());for(var nextStepNumber=stepNumber+1;nextStepNumber<=this.steps.length;){if(this.isStepPotentiallyVisible(this.getStepConfig(nextStepNumber)))return nextStepNumber;nextStepNumber++}return null}},{key:"getPreviousStepNumber",value:function(stepNumber){void 0===stepNumber&&(stepNumber=this.getCurrentStepNumber());for(var previousStepNumber=stepNumber-1;previousStepNumber>=0;){if(this.isStepPotentiallyVisible(this.getStepConfig(previousStepNumber)))return previousStepNumber;previousStepNumber--}return null}},{key:"isLastStep",value:function(stepNumber){return null===this.getNextStepNumber(stepNumber)}},{key:"isFirstStep",value:function(stepNumber){return null===this.getPreviousStepNumber(stepNumber)}},{key:"isStepPotentiallyVisible",value:function(stepConfig){return!!(stepConfig&&(this.isStepActuallyVisible(stepConfig)||void 0!==stepConfig.orphan&&stepConfig.orphan||void 0!==stepConfig.delay&&stepConfig.delay))}},{key:"isStepActuallyVisible",value:function(stepConfig){if(!stepConfig)return!1;var target=this.getStepTarget(stepConfig);return!!(target&&target.length&&target.is(":visible"))&&!!target.length}},{key:"next",value:function(){return this.gotoStep(this.getNextStepNumber())}},{key:"previous",value:function(){return this.gotoStep(this.getPreviousStepNumber(),-1)}},{key:"gotoStep",value:function(stepNumber,direction){if(stepNumber<0)return this.endTour();var stepConfig=this.getStepConfig(stepNumber);return null===stepConfig?this.endTour():this._gotoStep(stepConfig,direction)}},{key:"_gotoStep",value:function(stepConfig,direction){if(!stepConfig)return this.endTour();if(void 0!==stepConfig.delay&&stepConfig.delay&&!stepConfig.delayed)return stepConfig.delayed=!0,window.setTimeout(this._gotoStep.bind(this),stepConfig.delay,stepConfig,direction),this;if(!stepConfig.orphan&&!this.isStepActuallyVisible(stepConfig)){var fn=-1==direction?"getPreviousStepNumber":"getNextStepNumber";return this.gotoStep(this[fn](stepConfig.stepNumber),direction)}return this.hide(),this.fireEventHandlers("beforeRender",stepConfig),this.renderStep(stepConfig),this.fireEventHandlers("afterRender",stepConfig),this}},{key:"getStepConfig",value:function(stepNumber){if(null===stepNumber||stepNumber<0||stepNumber>=this.steps.length)return null;var stepConfig=this.normalizeStepConfig(this.steps[stepNumber]);return stepConfig=_jquery.default.extend(stepConfig,{stepNumber:stepNumber})}},{key:"normalizeStepConfig",value:function(stepConfig){return void 0!==stepConfig.reflex&&void 0===stepConfig.moveAfterClick&&(stepConfig.moveAfterClick=stepConfig.reflex),void 0!==stepConfig.element&&void 0===stepConfig.target&&(stepConfig.target=stepConfig.element),void 0!==stepConfig.content&&void 0===stepConfig.body&&(stepConfig.body=stepConfig.content),stepConfig=_jquery.default.extend({},this.stepDefaults,stepConfig),(stepConfig=_jquery.default.extend({},{attachTo:stepConfig.target,attachPoint:"after"},stepConfig)).attachTo&&(stepConfig.attachTo=(0,_jquery.default)(stepConfig.attachTo).first()),stepConfig}},{key:"getStepTarget",value:function(stepConfig){return stepConfig.target?(0,_jquery.default)(stepConfig.target):null}},{key:"fireEventHandlers",value:function(eventName,data){return void 0===this.eventHandlers[eventName]||this.eventHandlers[eventName].forEach((function(thisEvent){thisEvent.call(this,data)}),this),this}},{key:"addEventHandler",value:function(eventName,handler){return void 0===this.eventHandlers[eventName]&&(this.eventHandlers[eventName]=[]),this.eventHandlers[eventName].push(handler),this}},{key:"processStepListeners",value:function(stepConfig){if(this.listeners.push({node:this.currentStepNode,args:["click",'[data-role="next"]',_jquery.default.proxy(this.next,this)]},{node:this.currentStepNode,args:["click",'[data-role="previous"]',_jquery.default.proxy(this.previous,this)]},{node:this.currentStepNode,args:["click",'[data-role="end"]',_jquery.default.proxy(this.endTour,this)]},{node:(0,_jquery.default)('[data-flexitour="backdrop"]'),args:["click",_jquery.default.proxy(this.hide,this)]},{node:(0,_jquery.default)("body"),args:["keydown",_jquery.default.proxy(this.handleKeyDown,this)]}),stepConfig.moveOnClick){var targetNode=this.getStepTarget(stepConfig);this.listeners.push({node:targetNode,args:["click",_jquery.default.proxy((function(e){0===(0,_jquery.default)(e.target).parents('[data-flexitour="container"]').length&&window.setTimeout(_jquery.default.proxy(this.next,this),500)}),this)]})}return this.listeners.forEach((function(listener){listener.node.on.apply(listener.node,listener.args)})),this}},{key:"resetStepListeners",value:function(){return this.listeners&&this.listeners.forEach((function(listener){listener.node.off.apply(listener.node,listener.args)})),this.listeners=[],this}},{key:"renderStep",value:function(stepConfig){this.currentStepConfig=stepConfig,this.setCurrentStepNumber(stepConfig.stepNumber);var template=(0,_jquery.default)(this.getTemplateContent());return template.find('[data-placeholder="title"]').html(stepConfig.title),template.find('[data-placeholder="body"]').html(stepConfig.body),this.isFirstStep(stepConfig.stepNumber)?template.find('[data-role="previous"]').hide():template.find('[data-role="previous"]').prop("disabled",!1),this.isLastStep(stepConfig.stepNumber)?(template.find('[data-role="next"]').hide(),template.find('[data-role="end"]').removeClass("btn-secondary").addClass("btn-primary")):template.find('[data-role="next"]').prop("disabled",!1),template.find('[data-role="previous"]').attr("role","button"),template.find('[data-role="next"]').attr("role","button"),template.find('[data-role="end"]').attr("role","button"),stepConfig.template=template,this.addStepToPage(stepConfig),this.processStepListeners(stepConfig),this}},{key:"getTemplateContent",value:function(){return(0,_jquery.default)(this.templateContent).clone()}},{key:"addStepToPage",value:function(stepConfig){var currentStepNode=(0,_jquery.default)('<span data-flexitour="container"></span>').html(stepConfig.template).hide(),animationTarget=(0,_jquery.default)("body, html").stop(!0,!0);if(this.isStepActuallyVisible(stepConfig)){var targetNode=this.getStepTarget(stepConfig);targetNode.data("flexitour","target");var zIndex=this.calculateZIndex(targetNode);zIndex&&(stepConfig.zIndex=zIndex+1),stepConfig.zIndex&&currentStepNode.css("zIndex",stepConfig.zIndex+1),this.positionBackdrop(stepConfig),(0,_jquery.default)(document.body).append(currentStepNode),this.currentStepNode=currentStepNode,this.currentStepNode.css({top:0,left:0}),animationTarget.animate({scrollTop:this.calculateScrollTop(stepConfig)}).promise().then(function(){this.positionStep(stepConfig),this.revealStep(stepConfig)}.bind(this)).catch((function(){}))}else stepConfig.orphan&&(stepConfig.isOrphan=!0,stepConfig.attachTo=(0,_jquery.default)("body").first(),stepConfig.attachPoint="append",this.positionBackdrop(stepConfig),currentStepNode.addClass("orphan"),(0,_jquery.default)(document.body).append(currentStepNode),this.currentStepNode=currentStepNode,this.currentStepNode.offset(this.calculateStepPositionInPage()),this.currentStepNode.css("position","fixed"),this.currentStepPopper=new _popper.default((0,_jquery.default)("body"),this.currentStepNode[0],{removeOnDestroy:!0,placement:stepConfig.placement+"-start",arrowElement:'[data-role="arrow"]',modifiers:{hide:{enabled:!1},applyStyle:{onLoad:null,enabled:!1}}}),this.revealStep(stepConfig));return this}},{key:"revealStep",value:function(stepConfig){return this.currentStepNode.fadeIn("",_jquery.default.proxy((function(){this.announceStep(stepConfig),this.currentStepNode.focus(),window.setTimeout(_jquery.default.proxy((function(){this.currentStepNode&&this.currentStepNode.focus()}),this),100)}),this)),this}},{key:"announceStep",value:function(stepConfig){var stepId="tour-step-"+this.tourName+"-"+stepConfig.stepNumber;this.currentStepNode.attr("id",stepId);var bodyRegion=this.currentStepNode.find('[data-placeholder="body"]').first();bodyRegion.attr("id",stepId+"-body"),bodyRegion.attr("role","document");var headerRegion=this.currentStepNode.find('[data-placeholder="title"]').first();headerRegion.attr("id",stepId+"-title"),headerRegion.attr("aria-labelledby",stepId+"-body"),this.currentStepNode.attr("role","dialog"),this.currentStepNode.attr("tabindex",0),this.currentStepNode.attr("aria-labelledby",stepId+"-title"),this.currentStepNode.attr("aria-describedby",stepId+"-body");var target=this.getStepTarget(stepConfig);return target&&(target.attr("tabindex")||target.attr("tabindex",0),target.data("original-describedby",target.attr("aria-describedby")).attr("aria-describedby",stepId+"-body")),this.accessibilityShow(stepConfig),this}},{key:"handleKeyDown",value:function(e){var tabbableSelector="a[href], link[href], [draggable=true], [contenteditable=true], ";switch(tabbableSelector+=":input:enabled, [tabindex], button:enabled",e.keyCode){case 27:this.endTour();break;case 9:(function(){if(this.currentStepConfig.hasBackdrop){var currentIndex,nextIndex,nextNode,focusRelevant,activeElement=(0,_jquery.default)(document.activeElement),stepTarget=this.getStepTarget(this.currentStepConfig),tabbableNodes=(0,_jquery.default)(tabbableSelector),dialogContainer=(0,_jquery.default)('span[data-flexitour="container"]');if(stepTarget&&(tabbableNodes=tabbableNodes.filter((function(index,element){return null!==stepTarget&&(stepTarget.has(element).length||dialogContainer.has(element).length||stepTarget.is(element)||dialogContainer.is(element))}))),tabbableNodes.each((function(index,element){return!activeElement.is(element)||(currentIndex=index,!1)})),null!=currentIndex){var direction=1;e.shiftKey&&(direction=-1),nextIndex=currentIndex;do{nextIndex+=direction,nextNode=(0,_jquery.default)(tabbableNodes[nextIndex])}while(nextNode.length&&nextNode.is(":disabled")||nextNode.is(":hidden"));focusRelevant=!!nextNode.length&&((focusRelevant=nextNode.closest(stepTarget).length)||nextNode.closest(this.currentStepNode).length)}focusRelevant?nextNode.focus():e.shiftKey?this.currentStepNode.find(tabbableSelector).last().focus():this.currentStepConfig.isOrphan?this.currentStepNode.focus():stepTarget.focus(),e.preventDefault()}}).call(this)}}},{key:"startTour",value:function(startAt){if(this.storage&&void 0===startAt){var storageStartValue=this.storage.getItem(this.storageKey);if(storageStartValue){var storageStartAt=parseInt(storageStartValue,10);storageStartAt<=this.steps.length&&(startAt=storageStartAt)}}return void 0===startAt&&(startAt=this.getCurrentStepNumber()),this.fireEventHandlers("beforeStart",startAt),this.gotoStep(startAt),this.fireEventHandlers("afterStart",startAt),this}},{key:"restartTour",value:function(){return this.startTour(0)}},{key:"endTour",value:function(){if(this.fireEventHandlers("beforeEnd"),this.currentStepConfig){var previousTarget=this.getStepTarget(this.currentStepConfig);previousTarget&&(previousTarget.attr("tabindex")||previousTarget.attr("tabindex","-1"),previousTarget.focus())}return this.hide(!0),this.fireEventHandlers("afterEnd"),this}},{key:"hide",value:function(transition){if(this.fireEventHandlers("beforeHide"),this.currentStepNode&&this.currentStepNode.length&&(this.currentStepNode.hide(),this.currentStepPopper&&this.currentStepPopper.destroy()),this.currentStepConfig){var target=this.getStepTarget(this.currentStepConfig);target&&(target.data("original-labelledby")&&target.attr("aria-labelledby",target.data("original-labelledby")),target.data("original-describedby")&&target.attr("aria-describedby",target.data("original-describedby")),target.data("original-tabindex")&&target.attr("tabindex",target.data("tabindex"))),this.currentStepConfig=null}var fadeTime=0;if(transition&&(fadeTime=400),(0,_jquery.default)('[data-flexitour="step-background"]').remove(),(0,_jquery.default)('[data-flexitour="step-backdrop"]').removeAttr("data-flexitour"),(0,_jquery.default)('[data-flexitour="backdrop"]').fadeOut(fadeTime,(function(){(0,_jquery.default)(this).remove()})),this.currentStepNode&&this.currentStepNode.length){var stepId=this.currentStepNode.attr("id");if(stepId){var currentStepElement='[aria-describedby="'+stepId+'-body"]';(0,_jquery.default)(currentStepElement).removeAttr("tabindex"),(0,_jquery.default)(currentStepElement).removeAttr("aria-describedby")}}return this.resetStepListeners(),this.accessibilityHide(),this.fireEventHandlers("afterHide"),this.currentStepNode=null,this.currentStepPopper=null,this}},{key:"show",value:function(){var startAt=this.getCurrentStepNumber();return this.gotoStep(startAt)}},{key:"getStepContainer",value:function(){return(0,_jquery.default)(this.currentStepNode)}},{key:"calculateScrollTop",value:function(stepConfig){var scrollTop=(0,_jquery.default)(window).scrollTop(),viewportHeight=(0,_jquery.default)(window).height(),targetNode=this.getStepTarget(stepConfig);return scrollTop="top"===stepConfig.placement?targetNode.offset().top-viewportHeight/2:"bottom"===stepConfig.placement?targetNode.offset().top+targetNode.height()-viewportHeight/2:targetNode.height()<=.8*viewportHeight?targetNode.offset().top-(viewportHeight-targetNode.height())/2:targetNode.offset().top-.2*viewportHeight,scrollTop=Math.max(0,scrollTop),scrollTop=Math.min((0,_jquery.default)(document).height()-viewportHeight,scrollTop),Math.ceil(scrollTop)}},{key:"calculateStepPositionInPage",value:function(){var viewportHeight=(0,_jquery.default)(window).height(),stepHeight=this.currentStepNode.height(),viewportWidth=(0,_jquery.default)(window).width(),stepWidth=this.currentStepNode.width();return{top:Math.ceil((viewportHeight-stepHeight)/2),left:Math.ceil((viewportWidth-stepWidth)/2)}}},{key:"positionStep",value:function(stepConfig){var flipBehavior,content=this.currentStepNode;if(!content||!content.length)return this;switch(stepConfig.placement=this.recalculatePlacement(stepConfig),stepConfig.placement){case"left":flipBehavior=["left","right","top","bottom"];break;case"right":flipBehavior=["right","left","top","bottom"];break;case"top":flipBehavior=["top","bottom","right","left"];break;case"bottom":flipBehavior=["bottom","top","right","left"];break;default:flipBehavior="flip"}var target=this.getStepTarget(stepConfig),config={placement:stepConfig.placement+"-start",removeOnDestroy:!0,modifiers:{flip:{behaviour:flipBehavior},arrow:{element:'[data-role="arrow"]'}},onCreate:function(data){recalculateArrowPosition(data)},onUpdate:function(data){recalculateArrowPosition(data)}},recalculateArrowPosition=function(data){var placement=data.placement.split("-")[0],isVertical=-1!==["left","right"].indexOf(placement),arrowElement=data.instance.popper.querySelector('[data-role="arrow"]'),stepElement=(0,_jquery.default)(data.instance.popper.querySelector('[data-role="flexitour-step"]'));if(isVertical){var arrowHeight=parseFloat(window.getComputedStyle(arrowElement).height),arrowOffset=parseFloat(window.getComputedStyle(arrowElement).top),popperHeight=parseFloat(window.getComputedStyle(data.instance.popper).height),popperOffset=parseFloat(window.getComputedStyle(data.instance.popper).top),popperBorderWidth=parseFloat(stepElement.css("borderTopWidth")),popperBorderRadiusWidth=2*parseFloat(stepElement.css("borderTopLeftRadius")),arrowPos=arrowOffset+arrowHeight/2,maxPos=popperHeight+popperOffset-popperBorderWidth-popperBorderRadiusWidth,minPos=popperOffset+popperBorderWidth+popperBorderRadiusWidth;if(arrowPos>=maxPos||arrowPos<=minPos){var newArrowPos=0;newArrowPos=arrowPos>popperHeight/2?maxPos-arrowHeight:minPos+arrowHeight,(0,_jquery.default)(arrowElement).css("top",newArrowPos)}}else{var arrowWidth=parseFloat(window.getComputedStyle(arrowElement).width),_arrowOffset=parseFloat(window.getComputedStyle(arrowElement).left),popperWidth=parseFloat(window.getComputedStyle(data.instance.popper).width),_popperOffset=parseFloat(window.getComputedStyle(data.instance.popper).left),_popperBorderWidth=parseFloat(stepElement.css("borderTopWidth")),_popperBorderRadiusWidth=2*parseFloat(stepElement.css("borderTopLeftRadius")),_arrowPos=_arrowOffset+arrowWidth/2,_maxPos=popperWidth+_popperOffset-_popperBorderWidth-_popperBorderRadiusWidth,_minPos=_popperOffset+_popperBorderWidth+_popperBorderRadiusWidth;if(_arrowPos>=_maxPos||_arrowPos<=_minPos){var _newArrowPos=0;_newArrowPos=_arrowPos>popperWidth/2?_maxPos-arrowWidth:_minPos+arrowWidth,(0,_jquery.default)(arrowElement).css("left",_newArrowPos)}}},background=(0,_jquery.default)('[data-flexitour="step-background"]');return background.length&&(target=background),this.currentStepPopper=new _popper.default(target,content[0],config),this}},{key:"recalculatePlacement",value:function(stepConfig){var target=this.getStepTarget(stepConfig),widthContent=this.currentStepNode.width()+16,targetOffsetLeft=target.offset().left-10,targetOffsetRight=target.offset().left+target.width()+10,placement=stepConfig.placement;return-1!==["left","right"].indexOf(placement)&&targetOffsetLeft<widthContent+10&&targetOffsetRight+widthContent+10>document.documentElement.clientWidth&&(placement="top"),placement}},{key:"positionBackdrop",value:function(stepConfig){if(stepConfig.backdrop){this.currentStepConfig.hasBackdrop=!0;var backdrop=(0,_jquery.default)('<div data-flexitour="backdrop"></div>');if(stepConfig.zIndex?"append"===stepConfig.attachPoint?stepConfig.attachTo.append(backdrop):backdrop.insertAfter(stepConfig.attachTo):(0,_jquery.default)("body").append(backdrop),this.isStepActuallyVisible(stepConfig)){var background=(0,_jquery.default)('<div data-flexitour="step-background"></div>'),targetNode=this.getStepTarget(stepConfig),colorNode=targetNode;colorNode=(0,_jquery.default)("body"),background.css({width:targetNode.outerWidth()+10+10,height:targetNode.outerHeight()+10+10,left:targetNode.offset().left-10,top:targetNode.offset().top-10,backgroundColor:this.calculateInherittedBackgroundColor(colorNode)}),targetNode.offset().left<10&&background.css({width:targetNode.outerWidth()+targetNode.offset().left+10,left:targetNode.offset().left}),targetNode.offset().top<10&&background.css({height:targetNode.outerHeight()+targetNode.offset().top+10,top:targetNode.offset().top});var targetRadius=targetNode.css("borderRadius");targetRadius&&targetRadius!==(0,_jquery.default)("body").css("borderRadius")&&background.css("borderRadius",targetRadius);var targetPosition=this.calculatePosition(targetNode);"fixed"===targetPosition?background.css("top",0):"absolute"===targetPosition&&background.css("position","fixed");var fader=background.clone();fader.css({backgroundColor:backdrop.css("backgroundColor"),opacity:backdrop.css("opacity")}),fader.attr("data-flexitour","step-background-fader"),stepConfig.zIndex?"append"===stepConfig.attachPoint?stepConfig.attachTo.append(background):(fader.insertAfter(stepConfig.attachTo),background.insertAfter(stepConfig.attachTo)):((0,_jquery.default)("body").append(fader),(0,_jquery.default)("body").append(background)),targetNode.attr("data-flexitour","step-backdrop"),stepConfig.zIndex&&(backdrop.css("zIndex",stepConfig.zIndex),background.css("zIndex",stepConfig.zIndex+1),targetNode.css("zIndex",stepConfig.zIndex+2)),fader.fadeOut("2000",(function(){(0,_jquery.default)(this).remove()}))}}return this}},{key:"calculateZIndex",value:function(elem){for(elem=(0,_jquery.default)(elem);elem.length&&elem[0]!==document;){var position=elem.css("position");if("absolute"===position||"relative"===position||"fixed"===position){var value=parseInt(elem.css("zIndex"),10);if(!isNaN(value)&&0!==value)return value}elem=elem.parent()}return 0}},{key:"calculateInherittedBackgroundColor",value:function(elem){var fakeNode=(0,_jquery.default)("<div>").hide();(0,_jquery.default)("body").append(fakeNode);var fakeElemColor=fakeNode.css("backgroundColor");for(fakeNode.remove(),elem=(0,_jquery.default)(elem);elem.length&&elem[0]!==document;){var color=elem.css("backgroundColor");if(color!==fakeElemColor)return color;elem=elem.parent()}return null}},{key:"calculatePosition",value:function(elem){for(elem=(0,_jquery.default)(elem);elem.length&&elem[0]!==document;){var position=elem.css("position");if("static"!==position)return position;elem=elem.parent()}return null}},{key:"accessibilityShow",value:function(){var hideFunction=function(child){var flexitourRole=child.data("flexitour");if(flexitourRole)switch(flexitourRole){case"container":case"target":return}child.attr("aria-hidden")||(child.attr("data-has-hidden",!0),Aria.hide(child))};this.currentStepNode.siblings().each((function(index,node){hideFunction((0,_jquery.default)(node))})),this.currentStepNode.parentsUntil("body").siblings().each((function(index,node){hideFunction((0,_jquery.default)(node))}))}},{key:"accessibilityHide",value:function(){(0,_jquery.default)("[data-has-hidden]").each((function(index,node){var child;void 0!==(child=(0,_jquery.default)(node)).attr("data-has-hidden")&&(child.removeAttr("data-has-hidden"),Aria.unhide(child))}))}}],protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Tour}();return _exports.default=Tour,_exports.default}));

//# sourceMappingURL=tour.min.js.map